#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "DescFile.h"

DescFile::~DescFile(){
  if(descs!=NULL){
    for(int i=0;i<cols;i++){
      free(descs[i]);
    }
    free(descs);
  }
}
DescFile::DescFile (char *name,int c){
  cols=c;
  filename = name;
  descs=NULL;
  if((input=fopen(filename,"r"))==NULL){
    fprintf(stderr,"Nelze otevrit soubor s popisy dat %s\n",filename);
    exit(-1);
  }
  parse();
}

int DescFile::parse(){
  int buffer_size;
  char *buffer;
  char c;
  int i,j;
  descs =(char **)malloc(sizeof(char*)*cols);
  if(descs==NULL){
    fprintf(stderr,"Nelze alokovat dostatek pameti\n");
    exit(-1);
  }
  for(j=0;j<cols;j++){ 
    buffer = (char *)malloc(BUFFER_SIZE*sizeof(char));
    if(buffer==NULL){
      fprintf(stderr,"Nelze alokovat dostatek pameti\n");
      exit(-1);
    }
    else{
      buffer_size=BUFFER_SIZE;
    }
    c=fgetc(input);
    i=0;
    while(c!='\n' && c!=EOF){
      if(c!='\r'){
        buffer[i++]=c;
        if(i==buffer_size-1){
          if(realloc(buffer,(buffer_size+=BUFFER_SIZE)*sizeof(char))==NULL){
            fprintf(stderr,"Nelze alokovat dostatek pameti\n");
            exit(-1);
          } 
        }
      }
      c=fgetc(input);
    }
    buffer[i]='\0';
    if((c==EOF&&j!=cols-1)||i==0){
      fprintf(stderr,"Chyba v souboru s popisy dat\n");
      exit(-1);
    }
    descs[j]=buffer;
  }
}

void DescFile::printLines(){
  for(int i=0;i<cols;i++){
    if((i%LINES)==0&&i!=0){
      printf("Stisknete enter pro pokracovani ");
      getchar();
    }
    printf("%3d  -  %s\n",i+1,descs[i]);
  }
}
