#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "Parser.h"

Parser::~Parser(){
  if(data!=NULL){
    free(data);
  }
  if(desc!=NULL){
    free(desc);
  }
}
Parser::Parser (char *name){
  filename = name;
  parsed=false;
  data=NULL;
  desc=NULL;
  if((input=fopen(filename,"r"))==NULL){
    fprintf(stderr,"Nelze otevrit vstupni soubor %s\n",filename);
    exit(-1);
  }
}

int Parser::parse(){
  int buffer_size;
  char *buffer;
  char c;
  int i,j;
  int item;
  buffer = (char *)malloc(BUFFER_SIZE*sizeof(char));
  if(buffer==NULL){
    fprintf(stderr,"Nelze alokovat dostatek pameti\n");
    exit(-1);
  }
  else{
    buffer_size=BUFFER_SIZE;
  }
  c=fgetc(input);
  i=0;
  while(c!='\n' && c!=EOF){
    buffer[i++]=c;
    if(i==buffer_size-1){
      if(realloc(buffer,(buffer_size+=BUFFER_SIZE)*sizeof(char))==NULL){
        fprintf(stderr,"Nelze alokovat dostatek pameti\n");
        exit(-1);
      }
    }
    c=fgetc(input);
  }
  buffer[i]='\0';
  desc=buffer;
  if(c==EOF){
    fprintf(stderr,"Chyba ve vstupnim souboru s daty\n");
    exit(-1);
  }
  if(fscanf(input,"%d",&rows)!=1){
    fprintf(stderr,"Chyba ve vstupnim souboru s daty\n");
    exit(-1);
  }
  if(fscanf(input,"%d",&cols)!=1){
    fprintf(stderr,"Chyba ve vstupnim souboru s daty\n");
    exit(-1);
  }
  if((maxKat=(int *)malloc(cols * sizeof(int)))==NULL){
    fprintf(stderr,"Nelze alokovat dostatek pameti\n");
    exit(-1);
  }
  if((minKat=(int *)malloc(cols * sizeof(int)))==NULL){
    fprintf(stderr,"Nelze alokovat dostatek pameti\n");
    exit(-1);
  }
  if((data=(int **)malloc(rows * sizeof(int *)))==NULL){
    fprintf(stderr,"Nelze alokovat dostatek pameti\n");
    exit(-1);
  }
  for(i=0;i<cols;i++){
    maxKat[i]=INT_MIN;
    minKat[i]=INT_MAX;
  }
  for(i=0;i<rows;i++){
    if((data[i]=(int *)malloc(cols * sizeof(int)))==NULL){
      fprintf(stderr,"Nelze alokovat dostatek pameti\n");
      exit(-1);
    }
  }
  for(i=0;i<rows;i++){
    for(j=0;j<cols;j++){
      if(fscanf(input,"%d",&item)!=1){
        fprintf(stderr,"Chyba ve vstupnim souboru s daty\n");
        exit(-1);
      }

      data[i][j]=item;
      if(item>maxKat[j]){
        maxKat[j]=item;
      }
      if(item<minKat[j]){
        minKat[j]=item;
      }
    }
  }
  for(j=0;j<cols;j++){
    if(minKat[j]!=0){
      for(i=0;i<rows;i++){
        data[i][j]=data[i][j]-minKat[j];
      }
    }
    maxKat[j]=maxKat[j]-minKat[j]+1;
  }
  fclose(input);
  parsed=true;
  return true;
}

