#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include "Parser.h"
#include "DescFile.h"
#include "types.h"
#include "Vector.h"
#include "Combinations.h"
#include "Asoc.h"
#include "Test.h"
#include "TUI.h"

char *TUI::texts[]={"antecedentu","sukcedentu"};
char *TUI::textsProc[]={"podporu","spolehlivost"};

void sighndl(int sig){
  fprintf(stderr,"\nProgram byl prerusen. Vysledky nemusi byt kompletni.\n");
  exit(0);
}

Array TUI::readIntArray(){
  char znak='0';
  char numBuffer[NUMBUFFLEN];
  char *buffer = new char[BUFFLEN];
  int *vals = new int[16];
  int count=0;
  int i,j; 

  count = 0;
  znak=getchar();
  for(i=0;znak!='\n'&&i<BUFFLEN-1;i++){
    buffer[i]=znak;
    znak=getchar();
  }
  buffer[i]='\0';
  i=0;
  while(true){
    while((buffer[i]<'0'||buffer[i]>'9')&&buffer[i]!='\0'){
      i++;
    }
    if(buffer[i]=='\0'){
      break;
    }
    j=0;
    while(buffer[i]>='0'&&buffer[i]<='9'&&j<NUMBUFFLEN-1){
      numBuffer[j]=buffer[i];
      j++;
      i++;
    }
    numBuffer[j]='\0';
    sscanf(numBuffer,"%d",vals+count);
    count++;
  }
  delete buffer;
  Array ar;
  ar.size=count;
  ar.items=vals;
  return ar;
}

float TUI::readFloat(int variant){
  float retVal;
  char znak;
  int i,j;
  char numBuffer[NUMBUFFLEN];
  char *buffer = new char[BUFFLEN];

  while(TRUE){
    printf("Zadejte minimalni %s nalezenych asociaci (v procentech): ",
		textsProc[variant]);
    znak = getchar();
    for(i=0;znak!='\n'&&i<BUFFLEN-1;i++){
      buffer[i]=znak;
      znak=getchar();
    }
    buffer[i]='\0';
    i=0;
    while((buffer[i]<'0'||buffer[i]>'9')&&buffer[i]!='.'&&buffer[i]!='\0'){
      i++;
    }
    if(buffer[i]=='\0'){
      fprintf(stderr,"\nCislo bylo spatne zadano\n");
      continue;
    }
    j=0;
    while(((buffer[i]>='0'&&buffer[i]<='9')||buffer[i]=='.')&&j<NUMBUFFLEN-1){
      numBuffer[j]=buffer[i];
      j++;
      i++;
    }
    numBuffer[j]='\0';
    if(sscanf(numBuffer,"%f",&retVal)!=1){
      fprintf(stderr,"\nCislo bylo spatne zadano\n");
      continue;
    }
    if(retVal>100 || retVal<0){
      fprintf(stderr,"\nProcenta mohou byt jen v rozsahu 0-100\n");
      continue;
    }
    break;
  }
  delete buffer;
  return retVal;
}

Array TUI::readCols(int variant){
  int i,j;
  Array ar;
  while(true){
    printf("Zadejte sloupce %s (1-%d):",texts[variant],cols);
    ar = readIntArray();
    if(ar.size==0){
      fprintf(stderr,"\nMusite zadat alespon jeden sloupec\n");
      continue;
    }
    if(ar.size>cols){
      fprintf(stderr,"\nNemuzete zadat vice sloupcu nez jich je v tabulce\n");
      continue;
    }
    int err=0;
    for(i=0; i<ar.size; i++){
      if(ar.items[i]>cols || ar.items[i]<=0){
        if(err==0){
          fprintf(stderr,"\nJedno z cisel je mimo rozsah\n");
          err++;
        }
      }
      else{
        ar.items[i]--;
      }
    }
    if(err>0){
      continue;
    }
    for(i=0; i<ar.size; i++){
      for(j=i+1; j<ar.size; j++){
        if(ar.items[i]==ar.items[j]){
          if(err==0){
            fprintf(stderr,"\nNektery slpoupec byl zadan vicekrat\n");
            err++;
          }
        }
      }
    }
    if(err>0){
      continue;
    }
    break;
  }
  return ar;
}

void TUI::printUsage(){
  printf("\nProgram vyhledava asociace v kategorialnich datech.\n");
  printf("\nSpusteni: asoc [parametry]\n");
  printf("Parametry:  -d <soubor>  - jmeno datoveho souboru. "
		"Je povinny.\n");
  printf("            -o <soubor>  - vystupni soubor\n");
  printf("            -p <soubor>  - soubor s popisy sloupcu\n");
  printf("            -h           - vypise tuto napovedu a konci\n");
  printf("            -t           - u nalezenych asociaci vypise i"
		" ctyrpolni tabulky\n\n");
}

int main(int argc, char **argv){
  TUI *t = new TUI();
  int err = 1;
  Array ante;
  Array sukce;
  char *dataFile=NULL;
  char *outputFile=NULL;
  char *descFile=NULL;
  int tables=false;
  signal(SIGINT,sighndl);
  for(int i=1;i<argc;i++){
    if(strcmp(argv[i],"-d")==0){
      i++;
      if(i>=argc){
        TUI::printUsage();
        exit(-1);
      }
      dataFile=argv[i];
      continue;
    }
    if(strcmp(argv[i],"-o")==0){
      i++;
      if(i>=argc){
        TUI::printUsage();
        exit(-1);
      }
      outputFile=argv[i];
      continue;
    }
    if(strcmp(argv[i],"-p")==0){
      i++;
      if(i>=argc){
        TUI::printUsage();
        exit(-1);
      }
      descFile=argv[i];
      continue;
    }
    if(strcmp(argv[i],"-h")==0){
      TUI::printUsage();
      exit(-1);
    }
    if(strcmp(argv[i],"-t")==0){
      tables=true;
      continue;
    }
    TUI::printUsage();
    exit(-1);
  }
  if(dataFile==NULL){
    TUI::printUsage();
    exit(-1);
  }
  FILE *output;
  if(outputFile==NULL){
    output=stdout;
  }
  else{
    if((output=fopen(outputFile,"w"))==NULL){
      fprintf(stderr,"Nelze otevrit vystupni soubor %s\n",outputFile);
      exit(-1);
    }
  }

  Parser *p = new Parser(dataFile);
  t->setCols(p->getCols());
  DescFile *descF;
  if(descFile!=NULL){
    descF = new DescFile(descFile,p->getCols());
    printf("Tabulka ma tyto sloupce:\n");
    descF->printLines();
  }
  else{
    descF=NULL;
  }
  while(err!=0){
    err=0;
    ante=t->readCols(ANTE);
    sukce=t->readCols(SUKCE);
  
    for(int i=0;i<ante.size;i++){
      for(int j=0;j<sukce.size;j++){
        if(ante.items[i]==sukce.items[j]){
          if(err==0){
            fprintf(stderr,"\nSloupec se nemuze vyskytovat soucasne v "
		"antecedentu i sukcedentu\n");
            err++;
          }
        }
      }
    }
  }
  Asoc *asoc=new Asoc(p,ante,sukce,output,tables,descF);

  float proc=t->readFloat(SPOL);
  asoc->setMinConfidence(proc/100);
  proc=t->readFloat(PODP);
  asoc->setMinSupport(proc/100);
  fprintf(stderr,"Cekejte prosim, pocitam...\n");
  asoc->run();
  delete asoc;
}

