#include <stdlib.h>
#include <stdio.h>
#include "Vector.h"
#include "DescFile.h"
#include "Parser.h"
#include "types.h"
#include "Combinations.h"
#include "Asoc.h"
#include "Test.h"

Test::Test(Asoc *a,Parser *p,Array ar, Array s){
  int i,j;
  parser=p;
  ante=ar;
  sukce=s;
  asoc=a;
  descF=asoc->getDescFile();
  data=parser->getData();
  rows=parser->getRows();
  colls=parser->getCols();
  maxKat = parser->getMaxKat();
  minKat = parser->getMinKat();
  antc=1;
  sukcc=1;
  for(i=0;i<ante.size;i++){
    antc*=maxKat[ante.items[i]];
  }
  for(i=0;i<sukce.size;i++){
    sukcc*=maxKat[sukce.items[i]];
  }
  if((tables=(FourCellsTable **)malloc(antc*sizeof(FourCellsTable *)))==NULL){
    fprintf(stderr, "Nedostatek pameti\n");
    exit(-1);
  }
  for(i=0; i<antc; i++){
    if((tables[i]=(FourCellsTable *)calloc(sukcc,
		sizeof(FourCellsTable)))==NULL){
      fprintf(stderr, "Nedostatek pameti\n");
      exit(-1);
    }
  }
}

Test::~Test(){
  int i;
  for(i=0; i<antc; i++){
    free(tables[i]);
  }
  free(tables);
}

void Test::linesToTables(){
  for(int i=0;i<rows;i++){
    lineToTables(i);
  }
}

float Test::fundImpl(FourCellsTable tab) {
  if(tab.a==0 && tab.b==0){
    return -1;
  }
  return tab.a/(float)(tab.a+tab.b);
}

float Test::support(FourCellsTable tab) {
  return tab.a/(float)(tab.a+tab.b+tab.c+tab.d);
}

void Test::lineToTables(int row){
  int i,j,k;
  int a,s;
  a=data[row][ante.items[0]];
  s=data[row][sukce.items[0]];
  for(k=1;k<ante.size;k++){
    if(maxKat[ante.items[k]]!=0){
      a*=maxKat[ante.items[k]];
    }
    a+=data[row][ante.items[k]];
  }
  for(k=1;k<sukce.size;k++){
    if(maxKat[sukce.items[k]]!=0){
      s*=maxKat[sukce.items[k]];
    }
    s+=data[row][sukce.items[k]];
  }
  for(i=0;i<antc;i++){
    for(j=0;j<sukcc;j++){
      if(a==i){
        if(s==j){
          tables[i][j].a++;
        }
        else{
          tables[i][j].b++;
        }
      }
      else {
        if(s==j){
          tables[i][j].c++;
        }
        else{
          tables[i][j].d++;
        }
      }
    }
  }
}


int *Test::indToArray(int ind, Array sa){
  int k;
  int *retVal;
  if((retVal=(int *)malloc(sa.size*sizeof(int)))==NULL){
    fprintf(stderr, "Nedostatek pameti\n");
    exit(0);
  }
  for(k=sa.size-1;k>=0;k--){
    if(k>0){
      retVal[k]=ind%maxKat[sa.items[k]]+minKat[sa.items[k]];
      ind/=maxKat[sa.items[k]]; 
    }
    else {
      retVal[k]=ind+minKat[sa.items[k]];
    }
  }
  return retVal;
}

void Test::printTables(FILE *output, int tab){
  int i,j,k;
  int a,s;
  float p,sup;
  float minS = asoc->getMinSupport();
  float minC = asoc->getMinConfidence();
  int sCount=0;
  int cCount=0;
  for(i=0;i<antc;i++){
    for(j=0;j<sukcc;j++){
      p=fundImpl(tables[i][j]);
      sup=support(tables[i][j]);
      int conti=false;
      if(p<minC) {
	conti=true;
      }
      else {
        cCount++;
      }
      if(sup<minS){
	conti=true;
      }
      else {
        sCount++;
      }
      if(conti){
	continue;
      }
      int *indexes=indToArray(i, ante);
      fprintf(output,"\nJestlize ");
      if(descF==NULL){
        fprintf(output,"%d[%d] ",ante.items[ante.size-1]+1,
		indexes[ante.size-1]);
        for(k=ante.size-2;k>=0;k--){
          fprintf(output,"a %d[%d] ",ante.items[k]+1,indexes[k]);
        }
      }
      else{
        fprintf(output,"%s[%d] ",descF->descs[ante.items[ante.size-1]],
	indexes[ante.size-1]);
        for(k=ante.size-2;k>=0;k--){
          fprintf(output,"a %s[%d] ",descF->descs[ante.items[k]],indexes[k]);
        }
      }
      free(indexes);
      indexes=indToArray(j, sukce);
      fprintf(output,"potom ");
      if(descF==NULL){
        fprintf(output,"%d[%d] ",sukce.items[sukce.size-1]+1,
		indexes[sukce.size-1]);
        for(k=sukce.size-2;k>=0;k--){
          fprintf(output,"a %d[%d] ",sukce.items[k]+1,indexes[k]);
        }
      }
      else{
        fprintf(output,"%s[%d] ",descF->descs[sukce.items[sukce.size-1]],
		indexes[sukce.size-1]);
        for(k=sukce.size-2;k>=0;k--){
          fprintf(output,"a %s[%d] ",descF->descs[sukce.items[k]],indexes[k]);
        }
      }
      free(indexes);
      fprintf(output,"\nSe spolehlivosti %3.2f%% a podporou %3.2f%%\n",
		(p*100),(sup*100));
      if(tab==true){
        fprintf(output,"\t%d %d\n\t%d %d\n",tables[i][j].a,tables[i][j].b,
		tables[i][j].c,tables[i][j].d);
      }
    }
  }
  if(sCount==0){
    asoc->vyradAnte();
  }
  if(cCount==0){
    asoc->vyradSukce();
  }    
}
