/*
 * Autor: Martin Kot
 * Nazev: Prekladac
 * Studijni cislo: KOT119
 */

#define TRUE 1
#define FALSE 0
#include <iostream.h>
#include "Vector.h"

void Vector::resize(){
  void **nove;
  int i;
  length=length+MINDECL;
  if((nove = new (void *)[length])==NULL){
    cerr<<"Nedostatek pameti"<<endl;
    exit(0);
  }
  for(i=0;i<size;i++){
    nove[i]=vars[i];
  }
  delete vars;
  vars=nove;
}

Vector::Vector(){
  vars = new (void*)[MINDECL];
  size=0;
  length=MINDECL;
}
void Vector::add(void *var){
  if(size>=length){
    resize();
  }
  vars[size]=var;
  size++;
}

int Vector::exist(void *n){
  int i;
  for(i=0;i<size;i++){
    if(n==vars[i]){
      return TRUE;
    }
  }
  return FALSE;
}

void *Vector::elementAt(int i){ 
  if(i<0 || i>=size){
    return NULL;
  }
  return vars[i];
}

void Vector::setElementAt(int i,void *v){
  if(i<0 || i>=size){
    return;
  }
  vars[i]=v;
}

Vector *Vector::join(Vector *left, Vector *right){
  Vector *novy = new Vector();
  int p=left->getSize();
  int i;
  for(i=0;i<p;i++){
    novy->add(left->elementAt(i));
  }
  p=right->getSize();
  for(i=0;i<p;i++){
    novy->add(right->elementAt(i));
  }
  return novy;
}

void Vector::add(Vector *right){
  int p=right->getSize();
  int i;
  for(i=0;i<p;i++){
    add(right->elementAt(i));
  }
}



